<?php
require "../config/seguridad.php";
require "../config/conexion.php";
include "../includes/head.php";
include "menu.php";

if (!isset($_GET["id"])) die("ID no especificado.");

$id = intval($_GET["id"]);

$q = $conexion->prepare("SELECT * FROM bans WHERE id=? LIMIT 1");
$q->bind_param("i", $id);
$q->execute();
$r = $q->get_result();

if ($r->num_rows == 0) die("El ban no existe.");
$ban = $r->fetch_assoc();

if ($_POST) {
    $nick     = $_POST["nick"];
    $steam_64 = $_POST["steam_64"];
    $razon    = $_POST["razon"];
    $servidor = $_POST["servidor"];
    $estado   = $_POST["estado"];

    $up = $conexion->prepare("
        UPDATE bans 
        SET nick=?, steam_64=?, razon=?, servidor=?, estado=? 
        WHERE id=?
    ");
    $up->bind_param("sssssi", $nick, $steam_64, $razon, $servidor, $estado, $id);
    $up->execute();

    $log = $conexion->prepare("INSERT INTO logs(usuario,accion,ban_id) VALUES (?,?,?)");
    $accion = "Edición del ban";
    $log->bind_param("ssi", $_SESSION["usuario"], $accion, $id);
    $log->execute();

    echo "<script>alert('Ban actualizado'); window.location='bans.php';</script>";
    exit;
}
?>

<div class="main-content">
    <h2 class="title">Editar Ban #<?php echo $ban["id"]; ?></h2>

    <div class="card" style="max-width:650px;">
        <form method="POST">

            <label>Nick:</label>
            <input name="nick" class="form-input" value="<?php echo $ban['nick']; ?>">

            <label>Steam64:</label>
            <input name="steam_64" class="form-input" value="<?php echo $ban['steam_64']; ?>">

            <label>Razón:</label>
            <textarea name="razon" class="form-input"><?php echo $ban['razon']; ?></textarea>

            <label>Servidor:</label>
            <input name="servidor" class="form-input" value="<?php echo $ban['servidor']; ?>">

            <label>Estado:</label>
            <select name="estado" class="form-input">
                <option value="activo"   <?= $ban['estado']=='activo' ? 'selected':'' ?>>Activo</option>
                <option value="inactivo" <?= $ban['estado']=='inactivo' ? 'selected':'' ?>>Inactivo</option>
            </select>

            <button class="btn-neon" style="width:150px;">Guardar Cambios</button>
            <a href="bans.php" class="btn-danger">Cancelar</a>

        </form>
    </div>
</div>

<?php include "../includes/footer.php"; ?>
