<?php
require "../config/seguridad.php";
require "../config/conexion.php";
include "../includes/head.php";
include "menu.php";

$bans = $conexion->query("SELECT * FROM bans ORDER BY id DESC");
?>

<div class="main-content">
    <h2 class="title">Lista de Baneos</h2>
    <a href="nuevo_ban.php" class="btn-danger">Nuevo Ban</a>
    <table id="tablaBans" class="display">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nick</th>
                <th>Steam</th>
                <th>Razón</th>
                <th>Admin</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
        <?php while($b = $bans->fetch_assoc()) { ?>
            <tr>
                <td><?= $b["id"] ?></td>
                <td><?= $b["nick"] ?></td>
                <td><?= $b["steam_64"] ?></td>
                <td><?= $b["razon"] ?></td>
                <td><?= $b["admin"] ?></td>
                <td><?= $b["estado"] ?></td>
                <td>
                    <a href="editar_ban.php?id=<?= $b['id'] ?>" class="btn-neon">Editar</a>
                    <a href="desbanear.php?id=<?= $b['id'] ?>" class="btn-danger">Desbanear</a>
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>
</div>

<script>
$(document).ready(function() {
    $('#tablaBans').DataTable({
        pageLength: 10,
        language: {
            url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json"
        }
    });
});
</script>

<?php include "../includes/footer.php"; ?>
