<?php
require "../config/conexion.php";
require "../config/config.php";
require "openid.php";
session_start();

// Inicializar OpenID
require_once "LightOpenID.php";
$openid = new LightOpenID($_SERVER['HTTP_HOST']);

if(!$openid->mode) {
    $openid->identity = 'https://steamcommunity.com/openid';
    header('Location: '.$openid->authUrl());
    exit;
} elseif ($openid->mode == 'cancel') {
    echo 'El login de Steam fue cancelado.';
} else {
    if($openid->validate()) {
        $id = $openid->identity;
        preg_match("/^https:\/\/steamcommunity\.com\/openid\/id\/(\d+)$/", $id, $matches);
        $steamid = $matches[1];

        // Guardar SteamID en sesión
        $_SESSION['steamid'] = $steamid;

        // Registrar usuario en DB si no existe
        $q = $conexion->prepare("SELECT * FROM usuarios WHERE steamid=? LIMIT 1");
        $q->bind_param("s", $steamid);
        $q->execute();
        $r = $q->get_result();

        if($r->num_rows == 0) {
            $insert = $conexion->prepare("INSERT INTO usuarios(steamid, usuario) VALUES(?,?)");
            $usuario = "SteamUser".$steamid;
            $insert->bind_param("ss", $steamid, $usuario);
            $insert->execute();
        }

        $_SESSION['usuario'] = "SteamUser".$steamid;
        $_SESSION['rol'] = "admin"; // Temporal, puedes asignar según DB

        header("Location: https://banscs.bond/csbans/admin/dashboard.php");
        exit;
    } else {
        echo "No se pudo validar SteamID.";
    }
}
?>
