<?php
session_start();
require "../steam/SteamOpenID.php";
require "../config/conexion.php";

$steam = new SteamOpenID("https://banscs.bond/csbans/login/login_steam.php");

if (!isset($_GET["openid_mode"])) {
    header("Location: " . $steam->loginUrl());
    exit;
}

$steamID64 = $steam->validate();
if (!$steamID64) die("Error autenticando con Steam");

$check = $conexion->prepare("SELECT * FROM usuarios WHERE steam64=?");
$check->bind_param("s", $steamID64);
$check->execute();
$res = $check->get_result();

if ($res->num_rows == 1) {
    $user = $res->fetch_assoc();
    $_SESSION["usuario"] = $user["usuario"];
    $_SESSION["rol"] = $user["rol"];
    $_SESSION["steam64"] = $steamID64;
    header("Location: ../admin/dashboard.php");
    exit;
} else {
    $nuevoUser = "steam_" . substr($steamID64, -6);
    $rol = "moderador";
    
     $openid = "https://steamcommunity.com/openid/id/". $steamID64;

// Obtener SteamID64
$steamId64 = basename($openid);

     function steamId64ToSteamId($steam64_) {
    $Y = $steam64_ % 2;
    $Z = ($steam64_ - 76561197960265728 - $Y) / 2;
    return "STEAM_0:$Y:$Z";
}

$steamId = steamId64ToSteamId(intval($steamId64));


 

    $sql = $conexion->prepare("INSERT INTO usuarios (usuario, steam64, password, rol) VALUES (?, ?, '', ?)");
    $sql->bind_param("sss", $steamId, $steamID64, $rol);
    $sql->execute();
    $_SESSION["usuario"] = $steamId;
    $_SESSION["rol"] = $rol;
    $_SESSION["steam64"] = $steamID64;
    header("Location: ../admin/dashboard.php");
    exit;
}