<?php
require "../config/seguridad.php";
require "../config/conexion.php";
include "../includes/head.php";
include "menu.php";

$bans = $conexion->query("SELECT * FROM bans ORDER BY id DESC");
?>

<div class="main-content container my-4">
    <h2 class="title mb-3">Lista de Baneos</h2>
    <a href="nuevo_ban.php" class="btn btn-primary mb-3">Nuevo Ban</a>

    <table id="tablaBans" class="display table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nick</th>
                <th>Steam</th>
                <th>Razón</th>
                <th>Admin</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>

        <tbody>
        <?php while ($b = $bans->fetch_assoc()) { ?>
            
            <tr>
                <td><?= htmlspecialchars($b["id"]) ?></td>
                <td><?= htmlspecialchars($b["nick"]) ?></td>
                <td><?= htmlspecialchars($b["steam_64"]) ?></td>

                <!-- Botón para abrir el acordeón -->
                <td>
                    <button class="btn btn-info btn-sm toggle-razon" data-id="<?= $b['id'] ?>">
                        Ver Detalles
                    </button>
                </td>

                <td><?= htmlspecialchars($b["admin"]) ?></td>
                <td><?= htmlspecialchars($b["estado"]) ?></td>

                <td>
                    <a href="editar_ban.php?id=<?= urlencode($b['id']) ?>" class="btn btn-warning btn-sm">Editar</a>
                    <a href="actions/desbanear.php?id=<?= urlencode($b['id']) ?>" class="btn btn-danger btn-sm">Desbanear</a>
                </td>
            </tr>

            <!-- Acordeón con la razón REAL desde la BD -->
            <tr class="razon-row" id="razon-<?= $b['id'] ?>" style="display:none;">
                <td colspan="7">
                    <div class="accordion">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" 
                                        type="button"
                                        data-bs-toggle="collapse"
                                        data-bs-target="#razonContent-<?= $b['id'] ?>">
                                      <?= nl2br(htmlspecialchars($b["razon"])) ?>
                                </button>
                            </h2>

                          
                        </div>
                    </div>
                </td>
            </tr>

        <?php } ?>
        </tbody>
    </table>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css"/>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Mostrar/ocultar la fila del acordeón
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('toggle-razon')) {
        let id = e.target.getAttribute('data-id');
        let fila = document.getElementById('razon-' + id);
        fila.style.display = (fila.style.display === 'none' ? '' : 'none');
    }
});
</script>

<?php include "../includes/footer.php"; ?>
