<?php
session_start();
require "LightOpenID.php";

$host = $_SERVER['HTTP_HOST'];
$openid = new LightOpenID($host);

// Rutas absolutas del proyecto
$openid->returnUrl = "https://banscs.bond/cs/banscs/admin/dashboard.php";
$openid->trustRoot = "https://banscs.bond/cs/banscs/";

if (!$openid->mode) {
    $openid->identity = 'https://steamcommunity.com/openid';
    header('Location: ' . $openid->authUrl());
    exit;
} elseif ($openid->mode == 'cancel') {
    echo 'Login cancelado por el usuario.';
    exit;
} else {
    if ($openid->validate()) {
        $id = $openid->identity;
        preg_match("/^https?:\/\/steamcommunity\.com\/openid\/id\/(\d+)$/", $id, $matches);
        $steamid = $matches[1];

        $_SESSION['steamid'] = $steamid;
        $_SESSION['usuario'] = "SteamUser" . substr($steamid, -5);

        // Conexin a DB
        require __DIR__ . "../config/conexion.php";

        // Revisar si usuario existe
        $stmt = $conexion->prepare("SELECT * FROM usuarios WHERE steamid=?");
        $stmt->bind_param("s", $steamid);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows == 0) {
            $rol = 'admin';
            $insert = $conexion->prepare("INSERT INTO usuarios(steamid, usuario, rol) VALUES(?,?,?)");
            $insert->bind_param("sss", $steamid, $_SESSION['usuario'], $rol);
            $insert->execute();
        }

        header("Location: https://banscs.bond/cs/banscs/admin/dashboard.php");
        exit;

    } else {
        echo "Error al validar SteamID.";
        exit;
    }
}
?>
