<?php
// openid.php - Clase mínima OpenID para Steam
class SteamAuth {
    private $openid;

    public function __construct($url) {
        $this->openid = new LightOpenID($url);
    }

    public function loginUrl() {
        $this->openid->identity = 'https://steamcommunity.com/openid';
        return $this->openid->authUrl();
    }

    public function validate() {
        return $this->openid->validate();
    }

    public function getSteamID() {
        if ($this->validate()) {
            $id = $this->openid->identity;
            preg_match("/^https:\/\/steamcommunity\.com\/openid\/id\/(\d+)$/", $id, $matches);
            return $matches[1];
        }
        return false;
    }
}
?>
