<?php
class SteamOpenID {

    private $returnUrl;

    public function __construct($returnUrl) {
        $this->returnUrl = $returnUrl;
    }

    public function loginUrl() {
        $params = [
            'openid.ns'         => 'http://specs.openid.net/auth/2.0',
            'openid.mode'       => 'checkid_setup',
            'openid.return_to'  => $this->returnUrl,
            'openid.realm'      => $this->returnUrl,
            'openid.identity'   => 'http://specs.openid.net/auth/2.0/identifier_select',
            'openid.claimed_id' => 'http://specs.openid.net/auth/2.0/identifier_select'
        ];
        return 'https://steamcommunity.com/openid/login?' . http_build_query($params);
    }

    public function validate() {

        if (!isset($_GET["openid_claimed_id"])) return false;

        preg_match("/\/id\/(\d+)$/", $_GET["openid_claimed_id"], $matches);

        return isset($matches[1]) ? $matches[1] : false;
    }
}